(function() {
  /*
  Created by Rafa Dorado
  */
  require.config({
    paths: {
      // RequireJS plugin
      // text: "libs/require/text"

      // RequireJS plugin
      domReady: "libs/require/domReady",
      // json: 'libs/require/json'

      // underscore library
      underscore: "libs/underscore/underscore.min",
      //handlebars library
      Handlebars: "libs/handlebars/handlebars.runtime-v2.0.0",
      PrecompiledTemplates: 'templates/compiled-templates.min',
      // Backbone.js library TEST
      Backbone: "libs/backbone/backbone-1.1.2.min",
      //Backbone LocalStorage Plugin: https://github.com/jeromegn/Backbone.localStorage
      "Backbone.LocalStorage": "libs/backbone/backbone.localStorage.min",
      // jQuery
      jquery: "libs/jquery/jquery-1.11.0.min",
      // jQuery Mobile framework
      jqm: "libs/jquery.mobile/jquery.mobile-1.3.2.min",
      jqueryui: 'libs/jqueryui-amd',
      // jQuery Mobile plugin for Backbone views navigation
      jqmNavigator: "libs/jquery.mobile/jqmNavigator",
      base64: "libs/crypto/base64",
      //LIB FOR translating XML-JSON  http://www.terracoder.com/
      json2xml: "libs/xml.utils/json2xml",
      moment: 'libs/moment/moment.min',
      mobiscroll: "libs/mobiscroll/js/mobiscroll.custom-2.5.0.min"
    },
    shim: {
      Backbone: {
        deps: ["underscore", "jquery"],
        exports: "Backbone"
      },
      "Backbone.LocalStorage": {
        deps: ["underscore", "jquery", "Backbone"],
        exports: "Backbone.LocalStorage"
      },
      jqueryui: {
        exports: "jqueryui"
      },
      Handlebars: {
        exports: "Handlebars",
        deps: ["underscore", "jquery", "Backbone"]
      },
      underscore: {
        exports: "_"
      },
      jqm: {
        deps: ["jquery", "jqmNavigator"]
      },
      moment: {
        exports: "moment"
      },
      mobiscroll: {
        exports: "mobiscroll",
        deps: ['jquery', 'jqmNavigator', 'jqm']
      }
    }
  });

  require(["domReady", 'Handlebars', "jqm", 'moment', 'models/request/RequestModel', 'models/user/UserModel', 'collections/event/EventCollection', 'collections/objects/ObjectCollection', "views/login/LoginView", 'views/event/EventListView'], function(domReady, Handlebars, jqm, Moment, RequestModel, UserModel, EventCollection, ObjectCollection, LoginView, EventListView) {
    // domReady is RequireJS plugin that triggers when DOM is ready
    return domReady(function() {
      var _register_handlebars_filters, getFirstView, onDeviceReady, today;
      window.media_query_min_width = function(width) {
        return window.screen.width > (width - 1);
      };
      window.baseUrl = window.location.href.split(window.location.pathname)[0] + '/';
      window.isGuerrilla = function() {
        return window.baseUrl.indexOf('demo.farmerswife.com') !== -1;
      };
      window.isCompany = function(companyNameJS) {
        var result;
        result = false;
        if (companyNameJS === "rt1.tv" && window.FW_COMPANY_NAME === companyNameJS) {
          result = true;
        }
        return result;
      };
      today = new Date();
      window.MAXDATE = new Date('2029/12/31');
      window.html_entities = function(str) {
        return String(str).replace(/&/g, '&amp;').replace(/"/g, '&quot;').replace(/'/g, '&#39;').replace(/</g, '&lt;').replace(/>/g, '&gt;');
      };
      window.decode_html_entities = function(str) {
        return $('<div />').html(str).text();
      };
      window.html_newlines = function(str) {
        if (str != null) {
          return String(str).replace(/(\r\n|\n|\r)/gm, "<br>");
        }
      };
      window.__check_undefined = function(val) {
        if (!val) {
          val = '';
        }
        if (val === 'undefined') {
          val = '';
        }
        return val;
      };
      _register_handlebars_filters = function() {
        Handlebars.registerHelper('compare', function(lvalue, operator, rvalue, options) {
          var operators, result;
          if (arguments.length < 3) {
            throw new Error("Handlerbars Helper 'compare' needs 2 parameters");
          }
          if (!options) {
            options = rvalue;
            rvalue = operator;
            operator = "===";
          }
          operators = {
            '==': function(l, r) {
              return l === r;
            },
            '===': function(l, r) {
              return l === r;
            },
            '!=': function(l, r) {
              return l !== r;
            },
            '!==': function(l, r) {
              return l !== r;
            },
            '<': function(l, r) {
              return l < r;
            },
            '>': function(l, r) {
              return l > r;
            },
            '<=': function(l, r) {
              return l <= r;
            },
            '>=': function(l, r) {
              return l >= r;
            },
            'typeof': function(l, r) {
              return typeof l === r;
            }
          };
          if (!operators[operator]) {
            throw new Error("Handlerbars Helper 'compare' doesn't know the operator " + operator);
          }
          result = operators[operator](lvalue, rvalue);
          if (result) {
            return options.fn(this);
          } else {
            return options.inverse(this);
          }
        });
        Handlebars.registerHelper('maxlength', function(text) {
          if (text) {
            text = text.substr(0, 200);
            if (text.length === 200) {
              text = text + '...';
            }
          }
          return text;
        });
        Handlebars.registerHelper('json', function(text) {
          return JSON.stringify(text);
        });
        Handlebars.registerHelper('timeFloatToString', function(dayStartsAt, usesAMPM, timeFloat) {
          var amPm, hours, hrs, intHour, minutes;
          if (arguments.length < 3) {
            throw new Error("Handlerbars Helper 'timeFloatToString' needs 2 parameters");
          }
          hours = parseFloat(parseFloat(timeFloat) + dayStartsAt);
          minutes = Math.floor((hours % 1) * 60);
          intHour = Math.floor(hours);
          amPm = ' AM';
          if (usesAMPM === 1) {
            if (intHour >= 12 && intHour < 24) {
              amPm = ' PM';
            }
            if (intHour > 24) {
              hrs = intHour - 24;
            } else if (intHour > 12) {
              hrs = intHour - 12;
            } else if (intHour === 12 || intHour === 24) {
              hrs = 12;
            } else {
              hrs = String(intHour);
            }
            if (hrs < 10) {
              hrs = String(hrs);
            }
            if (minutes < 10) {
              minutes = '0' + String(minutes);
            }
            return hrs + ':' + minutes + amPm;
          } else {
            if (intHour >= 24) {
              hrs = intHour - 24;
            } else {
              hrs = intHour;
            }
            if (hrs < 10) {
              hrs = String(hrs);
            }
            if (minutes < 10) {
              minutes = '0' + String(minutes);
            }
            return hrs + ':' + minutes;
          }
        });
        Handlebars.registerHelper('timeago', function(date) {
          var dateArr, interval, month, seconds;
          if (date) {
            dateArr = date.split(/[^0-9]/);
            month = parseInt(dateArr[1], 10) - 1; //CHANGE MONTH FROM SERVER BECAUSE OF SAFARI, WHY STEVE? (January is 0 - Dec 11)
            date = new Date(dateArr[0], month, dateArr[2], dateArr[3], dateArr[4], dateArr[5]);
            today = 'Today';
            seconds = Math.floor((new Date() - date) / 1000);
            interval = Math.floor(seconds / 31536000);
            if (interval > 1) {
              return `${interval} years ago`;
            }
            interval = Math.floor(seconds / 2592000);
            if (interval > 1) {
              return `${interval} months ago`;
            }
            interval = Math.floor(seconds / 86400);
            if (interval > 1) {
              return `${interval} days ago`;
            }
            interval = Math.floor(seconds / 3600);
            if (interval > 1) {
              return today; //"#{interval} hours ago"
            }
            interval = Math.floor(seconds / 60);
            if (interval > 1) {
              return today; //"#{interval} minutes ago"
            }
            if (Math.floor(seconds) === 0) {
              return 'Just now';
            } else {
              return today; //Math.floor(seconds) + ' seconds ago'
            }
          }
        });
        Handlebars.registerHelper('beautyDate', function(date) {
          var d;
          if (date) {
            d = Moment(date);
            return d.format('dddd Do MMMM');
          }
        });
        Handlebars.registerHelper('beautyDateForTodos', function(date) {
          var d, str;
          str = '';
          if (date) {
            d = Moment(date);
            str += d.fromNow();
            str += ' , ';
            str += d.format('dddd Do MMMM');
          }
          return str;
        });
        Handlebars.registerHelper('beautyDateAndTimeForTodos', function(dateTime, alarmMinutes) {
          var d, str, time;
          str = '';
          if (dateTime) {
            d = Moment(dateTime);
            time = d.format('hh:mm');
            if (alarmMinutes) {
              str = `${alarmMinutes} min. before `;
            }
            str += `${time} ${d.format('dddd Do MMMM')}`;
          }
          return str;
        });
        return Handlebars.registerHelper('GetTimeFromDateTimeTodo', function(dateTime, amPm) {
          var d, time;
          time = '';
          if (dateTime) {
            d = Moment(dateTime);
            if (!amPm) {
              time = d.format('hh:mm');
            } else {
              time = d.format('hh:mm a');
            }
          }
          return time;
        });
      };
      getFirstView = function(mdl) {
        var ev, eventsCol, objCol;
        //TODAY EVENTS Collection
        ev = new EventCollection();
        eventsCol = ev.get_day_events(mdl, Moment());
        //FETCH OBJECTS COL
        objCol = new ObjectCollection();
        objCol.get_simple_objects(mdl);
        objCol.get_favorites_objects(mdl);
        return new EventListView(mdl, eventsCol);
      };
      onDeviceReady = function(desktop) {
        var NextView, reqMdl, stModel;
        _register_handlebars_filters();
        // Setting jQM pageContainer to #container div, this solves some jQM flickers & jumps
        // I covered it here: http://outof.me/fixing-flickers-jumps-of-jquery-mobile-transitions-in-phonegap-apps/
        $.mobile.pageContainer = $("#container");
        // Setting default transition to slide except Android
        if (navigator.userAgent.indexOf("Android") !== -1) {
          $.mobile.defaultPageTransition = "slide";
          $.mobile.defaultDialogTransition = "none";
        } else {
          $.mobile.defaultPageTransition = "slide";
        }
        reqMdl = new RequestModel();
        NextView = new LoginView(reqMdl); //SI NO LOGEADO, lo mando a LOGIN VIEW
        stModel = new UserModel({
          id: 1
        });
        // 1 CHECKEO SI TIENE SETTINGS GUARDADAS Y  API KEY
        stModel.fetch({
          success: function(mdl) {
            // 2 Obtengo la view segun las settings
            window.MAXDATE = new Date(mdl.get('maxDate'));
            return NextView = getFirstView(mdl);
          }
        });
        // 3 Push la nueva view
        return $.mobile.jqmNavigator.pushView(NextView);
      };
      if (navigator.userAgent.match(/(iPad|iPhone|Android)/)) {
        // This is running on a device so waiting for deviceready event
        // document.addEventListener('deviceready', onDeviceReady, false);
        return onDeviceReady(true);
      } else {
        // On desktop don't have to wait for anything
        return onDeviceReady(true);
      }
    });
  });

}).call(this);
